---
title: Markdown Demo
description: A quick tour of common Markdown elements.
icon: construction
---

This page demonstrates how Markdown renders in Flint.

## Headings and Text

Use **bold**, _italic_, and `inline code` to emphasize content.

## Lists

Here's an unordered list:

- Dash bullet item (uses `-`)
* Asterisk bullet item (uses `*`)
  * Nested lists (uses `*`)

And here's an ordered list:

1. Ordered item one
2. Ordered item two
  1. Nested ordered item
  2. Another nested ordered item
3. Ordered item three
4. Ordered item four
5. Ordered item five
  1. Nested ordered item
    1. Deep nested ordered item
    2. Another deep nested ordered item
  2. Second nested ordered item
6. Ordered item six
  - Nested unordered item
  - Another nested unordered item

## Quote

> Good content is simple, readable, and structured.

## Code Block

```php
<?php
echo "Hello from Flint!";
```

## Table

| Feature | Notes |
| --- | --- |
| Markdown | Fast to write |
| Blocks | Reusable content |
| Themes | Easy to customize |

## Media

### Image embed

Easily embed an image with: `![](/uploads/catjam.gif)`. Example:

![](/uploads/catjam.gif)

### Video embed

Easily embed youtube links with the same markdown you would use for an image. The bang `!` tells the CMS to embed it.

Here's an example: `![](https://youtu.be/dQw4w9WgXcQ)`. And here it is in action!

![](https://youtu.be/bWcASV2sey0)
